local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"

local kurumi_timepiont = Class(Widget, function(self, owner)
	Widget._ctor(self, "kurumi_timepiont")
	self.owner = owner
	self:SetPosition(0, 0, 0)
	self:SetScale(1,1,1)

	--
    self.num = self:AddChild(Text(BODYTEXTFONT, 33))
    self.num:SetHAlign(ANCHOR_MIDDLE)
    self.num:SetPosition(5, -50, 0)
	self.num:MoveToFront()
	
	--ȡ
	self.num.current = owner.currenttimepiont:value()
	self.num.max = owner.maxtimepiont:value()
	self.percent = self.num.current/self.num.max
	
	--
    self.anim = self:AddChild(UIAnim())
    self.anim:GetAnimState():SetBank("wet")
    self.anim:GetAnimState():SetBuild("kurumi_timepiont")
	self.anim:GetAnimState():PlayAnimation("anim")
	self.anim:GetAnimState():SetPercent("anim", self.percent * .99)
    self.anim:SetClickable(true)

	--¼
	owner:ListenForEvent("maxtimepiontdirty",function(owner,data) 		
		self.num.max = owner.maxtimepiont:value()
		self.percent = self.num.current/self.num.max  
	end)
	owner:ListenForEvent("currenttimepiontdirty",function(owner,data)		
		self.num.current = owner.currenttimepiont:value()
		self.percent = self.num.current/self.num.max  
	end)
	
	self:StartUpdating()
end)

function kurumi_timepiont:OnUpdate(dt)
	self.anim:GetAnimState():SetPercent("anim", self.percent * .99)
	local str = string.format("%3d/%3d",self.num.current,self.num.max)
	self.num:SetString(str)
end

return kurumi_timepiont












